# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1: Start with Cooperate
        return "C"
    
    current_round = len(my_history) + 1
    if current_round == 10:  # Final round: Defect unconditionally
        return "D"
    
    # Analyze opponent's code for patterns
    always_cooperate = "always return 'C'" in opponent_program_code or "return 'C'" in opponent_program_code.replace(" ", "")
    always_defect = "always return 'D'" in opponent_program_code or "return 'D'" in opponent_program_code.replace(" ", "")
    
    if always_cooperate:
        return "D"  # Exploit always-cooperate opponent
    elif always_defect:
        return "D"  # Always defect against always-defect opponent
    
    # Tit-for-Tat with Forgiveness
    last_opponent_move = opp_history[-1]
    if last_opponent_move == "C":
        return "C"
    else:
        # Check if opponent defected consecutively
        if len(opp_history) >= 2 and opp_history[-2] == "D":
            return "C"  # Forgive after two consecutive defections
        else:
            return "D"  # Tit-for-Tat retaliation